package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VenvioOs2Os3;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VenvioOs2Os3DaoImpl generated by UDA, 26-jun-2017 10:01:01.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VenvioOs2Os3DaoImpl implements VenvioOs2Os3Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VenvioOs2Os3> rwMap = new RowMapper<VenvioOs2Os3>() {
		public VenvioOs2Os3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VenvioOs2Os3(resultSet.getString("NUMEXP"),
					resultSet.getString("NUMERODOCUMENTO"),
					resultSet.getString("RAZONSOCIAL"),
					resultSet.getString("DIRECCION"),
					resultSet.getLong("PLANTILLA"),
					resultSet.getString("MUNICIPIOEMPRESA"),
					resultSet.getString("TERRITORIOEMPRESA"),
					resultSet.getString("CP"),
					resultSet.getString("TELEFONOEMPRESA"),
					resultSet.getString("FAXEMP060"),
					resultSet.getString("EMAEMP060"),
					resultSet.getString("HTTPEMP060"),
					resultSet.getString("DESCACTIVIDADECONOMICA"),
					resultSet.getString("ACTIVIDADECONOMICA"),
					resultSet.getString("MUNICIPIOCENTRO"),
					resultSet.getString("PROVINCIACENTRO"),
					resultSet.getString("DIRECCIONCENTRO"),
					resultSet.getString("INDANXNO"),
					resultSet.getString("INDANXSI"),
					resultSet.getString("APDOANEXO"),
					resultSet.getString("NUMAPERTURA"),
					resultSet.getString("PIE1"), resultSet.getString("PIE2"),
					resultSet.getString("DESCFIRMA"),
					resultSet.getString("FIRMA"),
					resultSet.getString("CLASECTRCAST"),
					resultSet.getString("CLASECTREUSK"),
					resultSet.getString("DIROS3"), resultSet.getString("NUEVA"));
		}
	};

	private RowMapper<VenvioOs2Os3> rwMapPK = new RowMapper<VenvioOs2Os3>() {
		public VenvioOs2Os3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VenvioOs2Os3(resultSet.getString("NUMEXP"),
					resultSet.getString("NUMERODOCUMENTO"),
					resultSet.getString("RAZONSOCIAL"),
					resultSet.getString("DIRECCION"),
					resultSet.getLong("PLANTILLA"),
					resultSet.getString("MUNICIPIOEMPRESA"),
					resultSet.getString("TERRITORIOEMPRESA"),
					resultSet.getString("CP"),
					resultSet.getString("TELEFONOEMPRESA"),
					resultSet.getString("FAXEMP060"),
					resultSet.getString("EMAEMP060"),
					resultSet.getString("HTTPEMP060"),
					resultSet.getString("DESCACTIVIDADECONOMICA"),
					resultSet.getString("ACTIVIDADECONOMICA"),
					resultSet.getString("MUNICIPIOCENTRO"),
					resultSet.getString("PROVINCIACENTRO"),
					resultSet.getString("DIRECCIONCENTRO"),
					resultSet.getString("INDANXNO"),
					resultSet.getString("INDANXSI"),
					resultSet.getString("APDOANEXO"),
					resultSet.getString("NUMAPERTURA"),
					resultSet.getString("PIE1"), resultSet.getString("PIE2"),
					resultSet.getString("DESCFIRMA"),
					resultSet.getString("FIRMA"),
					resultSet.getString("CLASECTRCAST"),
					resultSet.getString("CLASECTREUSK"),
					resultSet.getString("DIROS3"), resultSet.getString("NUEVA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the VenvioOs2Os3 table.
	 * 
	 *  venvioos2os3
	 *            VenvioOs2Os3
	 *  VenvioOs2Os3
	 *
	 * @param venvioos2os3 the venvioos 2 os 3
	 * @return the venvio os 2 os 3
	 */
	public VenvioOs2Os3 add(VenvioOs2Os3 venvioos2os3) {
		String query = "INSERT INTO VENVIO_OS2_OS3 (NUMEXP, NUMERODOCUMENTO, RAZONSOCIAL, DIRECCION, PLANTILLA, MUNICIPIOEMPRESA, TERRITORIOEMPRESA, CP, TELEFONOEMPRESA, FAXEMP_060, EMAEMP_060, HTTPEMP_060, DESC_ACTIVIDADECONOMICA, ACTIVIDADECONOMICA, MUNICIPIOCENTRO, PROVINCIACENTRO, DIRECCIONCENTRO, INDANX_NO, INDANX_SI, APDO_ANEXO, NUM_APERTURA, PIE1, PIE2, DESCFIRMA, FIRMA, CLASECTR_CAST, CLASECTR_EUSK, DIR_OS3, NUEVA) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, venvioos2os3.getNumexp(),
				venvioos2os3.getNumerodocumento(),
				venvioos2os3.getRazonsocial(), venvioos2os3.getDireccion(),
				venvioos2os3.getPlantilla(),
				venvioos2os3.getMunicipioempresa(),
				venvioos2os3.getTerritorioempresa(), venvioos2os3.getCp(),
				venvioos2os3.getTelefonoempresa(), venvioos2os3.getFaxemp060(),
				venvioos2os3.getEmaemp060(), venvioos2os3.getHttpemp060(),
				venvioos2os3.getDescActividadeconomica(),
				venvioos2os3.getActividadeconomica(),
				venvioos2os3.getMunicipiocentro(),
				venvioos2os3.getProvinciacentro(),
				venvioos2os3.getDireccioncentro(), venvioos2os3.getIndanxNo(),
				venvioos2os3.getIndanxSi(), venvioos2os3.getApdoAnexo(),
				venvioos2os3.getNumApertura(), venvioos2os3.getPie1(),
				venvioos2os3.getPie2(), venvioos2os3.getDescfirma(),
				venvioos2os3.getFirma(), venvioos2os3.getClasectrCast(),
				venvioos2os3.getClasectrEusk(), venvioos2os3.getDirOs3(),
				venvioos2os3.getNueva());
		return venvioos2os3;
	}

	/**
	 * Updates a single row in the VenvioOs2Os3 table.
	 * 
	 *  venvioos2os3
	 *            VenvioOs2Os3
	 *  VenvioOs2Os3
	 *
	 * @param venvioos2os3 the venvioos 2 os 3
	 * @return the venvio os 2 os 3
	 */
	public VenvioOs2Os3 update(VenvioOs2Os3 venvioos2os3) {
		String query = "UPDATE VENVIO_OS2_OS3 SET  WHERE NUMEXP=? AND NUMERODOCUMENTO=? AND RAZONSOCIAL=? AND DIRECCION=? AND PLANTILLA=? AND MUNICIPIOEMPRESA=? AND TERRITORIOEMPRESA=? AND CP=? AND TELEFONOEMPRESA=? AND FAXEMP_060=? AND EMAEMP_060=? AND HTTPEMP_060=? AND DESC_ACTIVIDADECONOMICA=? AND ACTIVIDADECONOMICA=? AND MUNICIPIOCENTRO=? AND PROVINCIACENTRO=? AND DIRECCIONCENTRO=? AND INDANX_NO=? AND INDANX_SI=? AND APDO_ANEXO=? AND NUM_APERTURA=? AND PIE1=? AND PIE2=? AND DESCFIRMA=? AND FIRMA=? AND CLASECTR_CAST=? AND CLASECTR_EUSK=? AND DIR_OS3=? AND NUEVA=?";
		this.jdbcTemplate.update(query, venvioos2os3.getNumexp(),
				venvioos2os3.getNumerodocumento(),
				venvioos2os3.getRazonsocial(), venvioos2os3.getDireccion(),
				venvioos2os3.getPlantilla(),
				venvioos2os3.getMunicipioempresa(),
				venvioos2os3.getTerritorioempresa(), venvioos2os3.getCp(),
				venvioos2os3.getTelefonoempresa(), venvioos2os3.getFaxemp060(),
				venvioos2os3.getEmaemp060(), venvioos2os3.getHttpemp060(),
				venvioos2os3.getDescActividadeconomica(),
				venvioos2os3.getActividadeconomica(),
				venvioos2os3.getMunicipiocentro(),
				venvioos2os3.getProvinciacentro(),
				venvioos2os3.getDireccioncentro(), venvioos2os3.getIndanxNo(),
				venvioos2os3.getIndanxSi(), venvioos2os3.getApdoAnexo(),
				venvioos2os3.getNumApertura(), venvioos2os3.getPie1(),
				venvioos2os3.getPie2(), venvioos2os3.getDescfirma(),
				venvioos2os3.getFirma(), venvioos2os3.getClasectrCast(),
				venvioos2os3.getClasectrEusk(), venvioos2os3.getDirOs3(),
				venvioos2os3.getNueva());
		return venvioos2os3;
	}

	/**
	 * Finds a single row in the VenvioOs2Os3 table.
	 * 
	 *  venvioos2os3
	 *            VenvioOs2Os3
	 *  VenvioOs2Os3
	 *
	 * @param venvioos2os3 the venvioos 2 os 3
	 * @return the venvio os 2 os 3
	 */
	@Transactional(readOnly = true)
	public VenvioOs2Os3 find(VenvioOs2Os3 venvioos2os3) {
		String query = "SELECT t1.NUMEXP NUMEXP, t1.NUMERODOCUMENTO NUMERODOCUMENTO, t1.RAZONSOCIAL RAZONSOCIAL, t1.DIRECCION DIRECCION, t1.PLANTILLA PLANTILLA, t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA, t1.TERRITORIOEMPRESA TERRITORIOEMPRESA, t1.CP CP, t1.TELEFONOEMPRESA TELEFONOEMPRESA, t1.FAXEMP_060 FAXEMP060, t1.EMAEMP_060 EMAEMP060, t1.HTTPEMP_060 HTTPEMP060, t1.DESC_ACTIVIDADECONOMICA DESCACTIVIDADECONOMICA, t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA, t1.MUNICIPIOCENTRO MUNICIPIOCENTRO, t1.PROVINCIACENTRO PROVINCIACENTRO, t1.DIRECCIONCENTRO DIRECCIONCENTRO, t1.INDANX_NO INDANXNO, t1.INDANX_SI INDANXSI, t1.APDO_ANEXO APDOANEXO, t1.NUM_APERTURA NUMAPERTURA, t1.PIE1 PIE1, t1.PIE2 PIE2, t1.DESCFIRMA DESCFIRMA, t1.FIRMA FIRMA, t1.CLASECTR_CAST CLASECTRCAST, t1.CLASECTR_EUSK CLASECTREUSK, t1.DIR_OS3 DIROS3, t1.NUEVA NUEVA FROM VENVIO_OS2_OS3 t1  WHERE t1.NUMEXP = ?  ";

		List<VenvioOs2Os3> venvioos2os3List = this.jdbcTemplate.query(query,
				this.rwMap, venvioos2os3.getNumexp());
		return (VenvioOs2Os3) DataAccessUtils.uniqueResult(venvioos2os3List);
	}

	/**
	 * Removes a single row in the VenvioOs2Os3 table.
	 * 
	 *  venvioos2os3            VenvioOs2Os3
	 *
	 * @param venvioos2os3 the venvioos 2 os 3
	 */
	public void remove(VenvioOs2Os3 venvioos2os3) {
		String query = "DELETE FROM VENVIO_OS2_OS3 WHERE NUMEXP=? AND NUMERODOCUMENTO=? AND RAZONSOCIAL=? AND DIRECCION=? AND PLANTILLA=? AND MUNICIPIOEMPRESA=? AND TERRITORIOEMPRESA=? AND CP=? AND TELEFONOEMPRESA=? AND FAXEMP_060=? AND EMAEMP_060=? AND HTTPEMP_060=? AND DESC_ACTIVIDADECONOMICA=? AND ACTIVIDADECONOMICA=? AND MUNICIPIOCENTRO=? AND PROVINCIACENTRO=? AND DIRECCIONCENTRO=? AND INDANX_NO=? AND INDANX_SI=? AND APDO_ANEXO=? AND NUM_APERTURA=? AND PIE1=? AND PIE2=? AND DESCFIRMA=? AND FIRMA=? AND CLASECTR_CAST=? AND CLASECTR_EUSK=? AND DIR_OS3=? AND NUEVA=?";
		this.jdbcTemplate.update(query, venvioos2os3.getNumexp(),
				venvioos2os3.getNumerodocumento(),
				venvioos2os3.getRazonsocial(), venvioos2os3.getDireccion(),
				venvioos2os3.getPlantilla(),
				venvioos2os3.getMunicipioempresa(),
				venvioos2os3.getTerritorioempresa(), venvioos2os3.getCp(),
				venvioos2os3.getTelefonoempresa(), venvioos2os3.getFaxemp060(),
				venvioos2os3.getEmaemp060(), venvioos2os3.getHttpemp060(),
				venvioos2os3.getDescActividadeconomica(),
				venvioos2os3.getActividadeconomica(),
				venvioos2os3.getMunicipiocentro(),
				venvioos2os3.getProvinciacentro(),
				venvioos2os3.getDireccioncentro(), venvioos2os3.getIndanxNo(),
				venvioos2os3.getIndanxSi(), venvioos2os3.getApdoAnexo(),
				venvioos2os3.getNumApertura(), venvioos2os3.getPie1(),
				venvioos2os3.getPie2(), venvioos2os3.getDescfirma(),
				venvioos2os3.getFirma(), venvioos2os3.getClasectrCast(),
				venvioos2os3.getClasectrEusk(), venvioos2os3.getDirOs3(),
				venvioos2os3.getNueva());
	}

	/**
	 * Finds a list of rows in the VenvioOs2Os3 table.
	 * 
	 *  venvioos2os3
	 *            VenvioOs2Os3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VenvioOs2Os3>
	 *
	 * @param venvioos2os3 the venvioos 2 os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VenvioOs2Os3> findAll(VenvioOs2Os3 venvioos2os3,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.NUMEXP NUMEXP,t1.NUMERODOCUMENTO NUMERODOCUMENTO,t1.RAZONSOCIAL RAZONSOCIAL,t1.DIRECCION DIRECCION,t1.PLANTILLA PLANTILLA,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.FAXEMP_060 FAXEMP060,t1.EMAEMP_060 EMAEMP060,t1.HTTPEMP_060 HTTPEMP060,t1.DESC_ACTIVIDADECONOMICA DESCACTIVIDADECONOMICA,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.MUNICIPIOCENTRO MUNICIPIOCENTRO,t1.PROVINCIACENTRO PROVINCIACENTRO,t1.DIRECCIONCENTRO DIRECCIONCENTRO,t1.INDANX_NO INDANXNO,t1.INDANX_SI INDANXSI,t1.APDO_ANEXO APDOANEXO,t1.NUM_APERTURA NUMAPERTURA,t1.PIE1 PIE1,t1.PIE2 PIE2,t1.DESCFIRMA DESCFIRMA,t1.FIRMA FIRMA,t1.CLASECTR_CAST CLASECTRCAST,t1.CLASECTR_EUSK CLASECTREUSK,t1.DIR_OS3 DIROS3,t1.NUEVA NUEVA ");
		query.append("FROM VENVIO_OS2_OS3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(venvioos2os3);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VenvioOs2Os3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the VenvioOs2Os3 table using like.
	 * 
	 *  venvioos2os3
	 *            VenvioOs2Os3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VenvioOs2Os3>
	 *
	 * @param venvioos2os3 the venvioos 2 os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VenvioOs2Os3> findAllLike(VenvioOs2Os3 venvioos2os3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.NUMEXP NUMEXP,t1.NUMERODOCUMENTO NUMERODOCUMENTO,t1.RAZONSOCIAL RAZONSOCIAL,t1.DIRECCION DIRECCION,t1.PLANTILLA PLANTILLA,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.FAXEMP_060 FAXEMP060,t1.EMAEMP_060 EMAEMP060,t1.HTTPEMP_060 HTTPEMP060,t1.DESC_ACTIVIDADECONOMICA DESCACTIVIDADECONOMICA,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.MUNICIPIOCENTRO MUNICIPIOCENTRO,t1.PROVINCIACENTRO PROVINCIACENTRO,t1.DIRECCIONCENTRO DIRECCIONCENTRO,t1.INDANX_NO INDANXNO,t1.INDANX_SI INDANXSI,t1.APDO_ANEXO APDOANEXO,t1.NUM_APERTURA NUMAPERTURA,t1.PIE1 PIE1,t1.PIE2 PIE2,t1.DESCFIRMA DESCFIRMA,t1.FIRMA FIRMA,t1.CLASECTR_CAST CLASECTRCAST,t1.CLASECTR_EUSK CLASECTREUSK,t1.DIR_OS3 DIROS3,t1.NUEVA NUEVA ");
		query.append("FROM VENVIO_OS2_OS3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(venvioos2os3,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VenvioOs2Os3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the VenvioOs2Os3 table.
	 * 
	 *  venvioos2os3
	 *            VenvioOs2Os3
	 *  Long
	 *
	 * @param venvioos2os3 the venvioos 2 os 3
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(VenvioOs2Os3 venvioos2os3) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VENVIO_OS2_OS3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(venvioos2os3);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the VenvioOs2Os3 table using like.
	 * 
	 *  venvioos2os3
	 *            VenvioOs2Os3
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param venvioos2os3 the venvioos 2 os 3
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(VenvioOs2Os3 venvioos2os3, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VENVIO_OS2_OS3 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(venvioos2os3,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of VenvioOs2Os3 selected for rup_table.
	 * 
	 *  venvioos2os3            VenvioOs2Os3
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VenvioOs2Os3>>
	 *
	 * @param venvioos2os3 the venvioos 2 os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VenvioOs2Os3>> reorderSelection(
			VenvioOs2Os3 venvioos2os3, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.NUMERODOCUMENTO NUMERODOCUMENTO,t1.RAZONSOCIAL RAZONSOCIAL,t1.DIRECCION DIRECCION,t1.PLANTILLA PLANTILLA,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.FAXEMP_060 FAXEMP060,t1.EMAEMP_060 EMAEMP060,t1.HTTPEMP_060 HTTPEMP060,t1.DESC_ACTIVIDADECONOMICA DESCACTIVIDADECONOMICA,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.MUNICIPIOCENTRO MUNICIPIOCENTRO,t1.PROVINCIACENTRO PROVINCIACENTRO,t1.DIRECCIONCENTRO DIRECCIONCENTRO,t1.INDANX_NO INDANXNO,t1.INDANX_SI INDANXSI,t1.APDO_ANEXO APDOANEXO,t1.NUM_APERTURA NUMAPERTURA,t1.PIE1 PIE1,t1.PIE2 PIE2,t1.DESCFIRMA DESCFIRMA,t1.FIRMA FIRMA,t1.CLASECTR_CAST CLASECTRCAST,t1.CLASECTR_EUSK CLASECTREUSK,t1.DIR_OS3 DIROS3,t1.NUEVA NUEVA ");
		// FROM
		query.append("FROM VENVIO_OS2_OS3 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(venvioos2os3,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getReorderQuery(
						query,
						jqGridRequestDto,
						VenvioOs2Os3.class,
						filterParamList,
						"NUMEXP,NUMERODOCUMENTO,RAZONSOCIAL,DIRECCION,PLANTILLA,MUNICIPIOEMPRESA,TERRITORIOEMPRESA,CP,TELEFONOEMPRESA,FAXEMP_060,EMAEMP_060,HTTPEMP_060,DESC_ACTIVIDADECONOMICA,ACTIVIDADECONOMICA,MUNICIPIOCENTRO,PROVINCIACENTRO,DIRECCIONCENTRO,INDANX_NO,INDANX_SI,APDO_ANEXO,NUM_APERTURA,PIE1,PIE2,DESCFIRMA,FIRMA,CLASECTR_CAST,CLASECTR_EUSK,DIR_OS3,NUEVA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VenvioOs2Os3>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            VenvioOs2Os3
	 *  searchParams            VenvioOs2Os3
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VenvioOs2Os3>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VenvioOs2Os3>> search(VenvioOs2Os3 filterParams,
			VenvioOs2Os3 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.NUMERODOCUMENTO NUMERODOCUMENTO,t1.RAZONSOCIAL RAZONSOCIAL,t1.DIRECCION DIRECCION,t1.PLANTILLA PLANTILLA,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.FAXEMP_060 FAXEMP060,t1.EMAEMP_060 EMAEMP060,t1.HTTPEMP_060 HTTPEMP060,t1.DESC_ACTIVIDADECONOMICA DESCACTIVIDADECONOMICA,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.MUNICIPIOCENTRO MUNICIPIOCENTRO,t1.PROVINCIACENTRO PROVINCIACENTRO,t1.DIRECCIONCENTRO DIRECCIONCENTRO,t1.INDANX_NO INDANXNO,t1.INDANX_SI INDANXSI,t1.APDO_ANEXO APDOANEXO,t1.NUM_APERTURA NUMAPERTURA,t1.PIE1 PIE1,t1.PIE2 PIE2,t1.DESCFIRMA DESCFIRMA,t1.FIRMA FIRMA,t1.CLASECTR_CAST CLASECTRCAST,t1.CLASECTR_EUSK CLASECTREUSK,t1.DIR_OS3 DIROS3,t1.NUEVA NUEVA ");
		// FROM
		query.append("FROM VENVIO_OS2_OS3 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getSearchQuery(
						query,
						jqGridRequestDto,
						VenvioOs2Os3.class,
						filterParamList,
						searchSQL,
						searchParamList,
						from_alias,
						"NUMEXP,NUMERODOCUMENTO,RAZONSOCIAL,DIRECCION,PLANTILLA,MUNICIPIOEMPRESA,TERRITORIOEMPRESA,CP,TELEFONOEMPRESA,FAXEMP_060,EMAEMP_060,HTTPEMP_060,DESC_ACTIVIDADECONOMICA,ACTIVIDADECONOMICA,MUNICIPIOCENTRO,PROVINCIACENTRO,DIRECCIONCENTRO,INDANX_NO,INDANX_SI,APDO_ANEXO,NUM_APERTURA,PIE1,PIE2,DESCFIRMA,FIRMA,CLASECTR_CAST,CLASECTR_EUSK,DIR_OS3,NUEVA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VenvioOs2Os3>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filtervenvioos2os3            VenvioOs2Os3
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filtervenvioos2os3 the filtervenvioos 2 os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(VenvioOs2Os3 filtervenvioos2os3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.NUMERODOCUMENTO NUMERODOCUMENTO,t1.RAZONSOCIAL RAZONSOCIAL,t1.DIRECCION DIRECCION,t1.PLANTILLA PLANTILLA,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.FAXEMP_060 FAXEMP060,t1.EMAEMP_060 EMAEMP060,t1.HTTPEMP_060 HTTPEMP060,t1.DESC_ACTIVIDADECONOMICA DESCACTIVIDADECONOMICA,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.MUNICIPIOCENTRO MUNICIPIOCENTRO,t1.PROVINCIACENTRO PROVINCIACENTRO,t1.DIRECCIONCENTRO DIRECCIONCENTRO,t1.INDANX_NO INDANXNO,t1.INDANX_SI INDANXSI,t1.APDO_ANEXO APDOANEXO,t1.NUM_APERTURA NUMAPERTURA,t1.PIE1 PIE1,t1.PIE2 PIE2,t1.DESCFIRMA DESCFIRMA,t1.FIRMA FIRMA,t1.CLASECTR_CAST CLASECTRCAST,t1.CLASECTR_EUSK CLASECTREUSK,t1.DIR_OS3 DIROS3,t1.NUEVA NUEVA ");
		// FROM
		query.append("FROM VENVIO_OS2_OS3 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(
				filtervenvioos2os3, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(
						jqGridRequestDto,
						VenvioOs2Os3.class,
						query,
						params,
						"NUMEXP,NUMERODOCUMENTO,RAZONSOCIAL,DIRECCION,PLANTILLA,MUNICIPIOEMPRESA,TERRITORIOEMPRESA,CP,TELEFONOEMPRESA,FAXEMP_060,EMAEMP_060,HTTPEMP_060,DESC_ACTIVIDADECONOMICA,ACTIVIDADECONOMICA,MUNICIPIOCENTRO,PROVINCIACENTRO,DIRECCIONCENTRO,INDANX_NO,INDANX_SI,APDO_ANEXO,NUM_APERTURA,PIE1,PIE2,DESCFIRMA,FIRMA,CLASECTR_CAST,CLASECTR_EUSK,DIR_OS3,NUEVA");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VenvioOs2Os3 entity.
	 * 
	 *  venvioos2os3            VenvioOs2Os3 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param venvioos2os3 the venvioos 2 os 3
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(VenvioOs2Os3 venvioos2os3) {

		StringBuilder where = new StringBuilder(
				VenvioOs2Os3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (venvioos2os3 != null && venvioos2os3.getNumexp() != null) {
			where.append(" AND t1.NUMEXP = ?");
			params.add(venvioos2os3.getNumexp());
		}
		if (venvioos2os3 != null && venvioos2os3.getNumerodocumento() != null) {
			where.append(" AND t1.NUMERODOCUMENTO = ?");
			params.add(venvioos2os3.getNumerodocumento());
		}
		if (venvioos2os3 != null && venvioos2os3.getRazonsocial() != null) {
			where.append(" AND t1.RAZONSOCIAL = ?");
			params.add(venvioos2os3.getRazonsocial());
		}
		if (venvioos2os3 != null && venvioos2os3.getDireccion() != null) {
			where.append(" AND t1.DIRECCION = ?");
			params.add(venvioos2os3.getDireccion());
		}
		if (venvioos2os3 != null && venvioos2os3.getPlantilla() != null) {
			where.append(" AND t1.PLANTILLA = ?");
			params.add(venvioos2os3.getPlantilla());
		}
		if (venvioos2os3 != null && venvioos2os3.getMunicipioempresa() != null) {
			where.append(" AND t1.MUNICIPIOEMPRESA = ?");
			params.add(venvioos2os3.getMunicipioempresa());
		}
		if (venvioos2os3 != null && venvioos2os3.getTerritorioempresa() != null) {
			where.append(" AND t1.TERRITORIOEMPRESA = ?");
			params.add(venvioos2os3.getTerritorioempresa());
		}
		if (venvioos2os3 != null && venvioos2os3.getCp() != null) {
			where.append(" AND t1.CP = ?");
			params.add(venvioos2os3.getCp());
		}
		if (venvioos2os3 != null && venvioos2os3.getTelefonoempresa() != null) {
			where.append(" AND t1.TELEFONOEMPRESA = ?");
			params.add(venvioos2os3.getTelefonoempresa());
		}
		if (venvioos2os3 != null && venvioos2os3.getFaxemp060() != null) {
			where.append(" AND t1.FAXEMP_060 = ?");
			params.add(venvioos2os3.getFaxemp060());
		}
		if (venvioos2os3 != null && venvioos2os3.getEmaemp060() != null) {
			where.append(" AND t1.EMAEMP_060 = ?");
			params.add(venvioos2os3.getEmaemp060());
		}
		if (venvioos2os3 != null && venvioos2os3.getHttpemp060() != null) {
			where.append(" AND t1.HTTPEMP_060 = ?");
			params.add(venvioos2os3.getHttpemp060());
		}
		if (venvioos2os3 != null
				&& venvioos2os3.getDescActividadeconomica() != null) {
			where.append(" AND t1.DESC_ACTIVIDADECONOMICA = ?");
			params.add(venvioos2os3.getDescActividadeconomica());
		}
		if (venvioos2os3 != null
				&& venvioos2os3.getActividadeconomica() != null) {
			where.append(" AND t1.ACTIVIDADECONOMICA = ?");
			params.add(venvioos2os3.getActividadeconomica());
		}
		if (venvioos2os3 != null && venvioos2os3.getMunicipiocentro() != null) {
			where.append(" AND t1.MUNICIPIOCENTRO = ?");
			params.add(venvioos2os3.getMunicipiocentro());
		}
		if (venvioos2os3 != null && venvioos2os3.getProvinciacentro() != null) {
			where.append(" AND t1.PROVINCIACENTRO = ?");
			params.add(venvioos2os3.getProvinciacentro());
		}
		if (venvioos2os3 != null && venvioos2os3.getDireccioncentro() != null) {
			where.append(" AND t1.DIRECCIONCENTRO = ?");
			params.add(venvioos2os3.getDireccioncentro());
		}
		if (venvioos2os3 != null && venvioos2os3.getIndanxNo() != null) {
			where.append(" AND t1.INDANX_NO = ?");
			params.add(venvioos2os3.getIndanxNo());
		}
		if (venvioos2os3 != null && venvioos2os3.getIndanxSi() != null) {
			where.append(" AND t1.INDANX_SI = ?");
			params.add(venvioos2os3.getIndanxSi());
		}
		if (venvioos2os3 != null && venvioos2os3.getApdoAnexo() != null) {
			where.append(" AND t1.APDO_ANEXO = ?");
			params.add(venvioos2os3.getApdoAnexo());
		}
		if (venvioos2os3 != null && venvioos2os3.getNumApertura() != null) {
			where.append(" AND t1.NUM_APERTURA = ?");
			params.add(venvioos2os3.getNumApertura());
		}
		if (venvioos2os3 != null && venvioos2os3.getPie1() != null) {
			where.append(" AND t1.PIE1 = ?");
			params.add(venvioos2os3.getPie1());
		}
		if (venvioos2os3 != null && venvioos2os3.getPie2() != null) {
			where.append(" AND t1.PIE2 = ?");
			params.add(venvioos2os3.getPie2());
		}
		if (venvioos2os3 != null && venvioos2os3.getDescfirma() != null) {
			where.append(" AND t1.DESCFIRMA = ?");
			params.add(venvioos2os3.getDescfirma());
		}
		if (venvioos2os3 != null && venvioos2os3.getFirma() != null) {
			where.append(" AND t1.FIRMA = ?");
			params.add(venvioos2os3.getFirma());
		}
		if (venvioos2os3 != null && venvioos2os3.getClasectrCast() != null) {
			where.append(" AND t1.CLASECTR_CAST = ?");
			params.add(venvioos2os3.getClasectrCast());
		}
		if (venvioos2os3 != null && venvioos2os3.getClasectrEusk() != null) {
			where.append(" AND t1.CLASECTR_EUSK = ?");
			params.add(venvioos2os3.getClasectrEusk());
		}
		if (venvioos2os3 != null && venvioos2os3.getDirOs3() != null) {
			where.append(" AND t1.DIR_OS3 = ?");
			params.add(venvioos2os3.getDirOs3());
		}
		if (venvioos2os3 != null && venvioos2os3.getNueva() != null) {
			where.append(" AND t1.NUEVA = ?");
			params.add(venvioos2os3.getNueva());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VenvioOs2Os3 entity.
	 * 
	 *  venvioos2os3            VenvioOs2Os3 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param venvioos2os3 the venvioos 2 os 3
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(VenvioOs2Os3 venvioos2os3,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VenvioOs2Os3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (venvioos2os3 != null && venvioos2os3.getNumexp() != null) {
			where.append(" AND UPPER(t1.NUMEXP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getNumexp().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getNumexp().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMEXP IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getNumerodocumento() != null) {
			where.append(" AND UPPER(t1.NUMERODOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getNumerodocumento().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ venvioos2os3.getNumerodocumento().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMERODOCUMENTO IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getRazonsocial() != null) {
			where.append(" AND UPPER(t1.RAZONSOCIAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getRazonsocial().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getRazonsocial().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RAZONSOCIAL IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getDireccion() != null) {
			where.append(" AND UPPER(t1.DIRECCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getDireccion().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getDireccion().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DIRECCION IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getPlantilla() != null) {
			where.append(" AND t1.PLANTILLA = ?");
			params.add(venvioos2os3.getPlantilla());
		}
		if (venvioos2os3 != null && venvioos2os3.getMunicipioempresa() != null) {
			where.append(" AND UPPER(t1.MUNICIPIOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getMunicipioempresa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ venvioos2os3.getMunicipioempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MUNICIPIOEMPRESA IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getTerritorioempresa() != null) {
			where.append(" AND UPPER(t1.TERRITORIOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getTerritorioempresa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ venvioos2os3.getTerritorioempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TERRITORIOEMPRESA IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getCp() != null) {
			where.append(" AND UPPER(t1.CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getCp().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getCp().toUpperCase() + "%");
			}
			where.append(" AND t1.CP IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getTelefonoempresa() != null) {
			where.append(" AND UPPER(t1.TELEFONOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getTelefonoempresa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ venvioos2os3.getTelefonoempresa().toUpperCase() + "%");
			}
			where.append(" AND t1.TELEFONOEMPRESA IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getFaxemp060() != null) {
			where.append(" AND UPPER(t1.FAXEMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getFaxemp060().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getFaxemp060().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.FAXEMP_060 IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getEmaemp060() != null) {
			where.append(" AND UPPER(t1.EMAEMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getEmaemp060().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getEmaemp060().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.EMAEMP_060 IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getHttpemp060() != null) {
			where.append(" AND UPPER(t1.HTTPEMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getHttpemp060().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getHttpemp060().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HTTPEMP_060 IS NOT NULL");
		}
		if (venvioos2os3 != null
				&& venvioos2os3.getDescActividadeconomica() != null) {
			where.append(" AND UPPER(t1.DESC_ACTIVIDADECONOMICA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getDescActividadeconomica()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ venvioos2os3.getDescActividadeconomica()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_ACTIVIDADECONOMICA IS NOT NULL");
		}
		if (venvioos2os3 != null
				&& venvioos2os3.getActividadeconomica() != null) {
			where.append(" AND UPPER(t1.ACTIVIDADECONOMICA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getActividadeconomica().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ venvioos2os3.getActividadeconomica().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ACTIVIDADECONOMICA IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getMunicipiocentro() != null) {
			where.append(" AND UPPER(t1.MUNICIPIOCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getMunicipiocentro().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ venvioos2os3.getMunicipiocentro().toUpperCase() + "%");
			}
			where.append(" AND t1.MUNICIPIOCENTRO IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getProvinciacentro() != null) {
			where.append(" AND UPPER(t1.PROVINCIACENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getProvinciacentro().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ venvioos2os3.getProvinciacentro().toUpperCase() + "%");
			}
			where.append(" AND t1.PROVINCIACENTRO IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getDireccioncentro() != null) {
			where.append(" AND UPPER(t1.DIRECCIONCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getDireccioncentro().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ venvioos2os3.getDireccioncentro().toUpperCase() + "%");
			}
			where.append(" AND t1.DIRECCIONCENTRO IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getIndanxNo() != null) {
			where.append(" AND UPPER(t1.INDANX_NO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getIndanxNo().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getIndanxNo().toUpperCase() + "%");
			}
			where.append(" AND t1.INDANX_NO IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getIndanxSi() != null) {
			where.append(" AND UPPER(t1.INDANX_SI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getIndanxSi().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getIndanxSi().toUpperCase() + "%");
			}
			where.append(" AND t1.INDANX_SI IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getApdoAnexo() != null) {
			where.append(" AND UPPER(t1.APDO_ANEXO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getApdoAnexo().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getApdoAnexo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.APDO_ANEXO IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getNumApertura() != null) {
			where.append(" AND UPPER(t1.NUM_APERTURA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getNumApertura().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getNumApertura().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NUM_APERTURA IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getPie1() != null) {
			where.append(" AND UPPER(t1.PIE1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getPie1().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getPie1().toUpperCase() + "%");
			}
			where.append(" AND t1.PIE1 IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getPie2() != null) {
			where.append(" AND UPPER(t1.PIE2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getPie2().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getPie2().toUpperCase() + "%");
			}
			where.append(" AND t1.PIE2 IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getDescfirma() != null) {
			where.append(" AND UPPER(t1.DESCFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getDescfirma().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getDescfirma().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESCFIRMA IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getFirma() != null) {
			where.append(" AND UPPER(t1.FIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getFirma().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getFirma().toUpperCase() + "%");
			}
			where.append(" AND t1.FIRMA IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getClasectrCast() != null) {
			where.append(" AND UPPER(t1.CLASECTR_CAST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getClasectrCast().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getClasectrCast().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CLASECTR_CAST IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getClasectrEusk() != null) {
			where.append(" AND UPPER(t1.CLASECTR_EUSK) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getClasectrEusk().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getClasectrEusk().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CLASECTR_EUSK IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getDirOs3() != null) {
			where.append(" AND UPPER(t1.DIR_OS3) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getDirOs3().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getDirOs3().toUpperCase() + "%");
			}
			where.append(" AND t1.DIR_OS3 IS NOT NULL");
		}
		if (venvioos2os3 != null && venvioos2os3.getNueva() != null) {
			where.append(" AND UPPER(t1.NUEVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2os3.getNueva().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2os3.getNueva().toUpperCase() + "%");
			}
			where.append(" AND t1.NUEVA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
